<?php
require_once dirname(__DIR__, 2) . '/config/config.php';

// Check if user is logged in, if not then redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php");
    exit;
}

$group_name = "";
$group_name_err = "";

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){
    // Validate group name
    if(empty(trim($_POST["group_name"]))){ 
        $group_name_err = "Please enter a group name.";
    } else{
        $group_name = trim($_POST["group_name"]);
        // Potentially add more validation (length, characters, uniqueness if needed)
    }

    // Check input errors before inserting in database
    if(empty($group_name_err)){
        // Prepare an insert statement for the groups table
        $sql_group = "INSERT INTO groups (name, owner_id) VALUES (:name, :owner_id)";
        
        if($stmt_group = $pdo->prepare($sql_group)){
            // Bind variables to the prepared statement as parameters
            $stmt_group->bindParam(":name", $param_name, PDO::PARAM_STR);
            $stmt_group->bindParam(":owner_id", $param_owner_id, PDO::PARAM_INT);
            
            // Set parameters
            $param_name = $group_name;
            $param_owner_id = $_SESSION["id"]; // User creating the group is the owner
            
            // Attempt to execute the prepared statement
            if($stmt_group->execute()){ 
                // Get the ID of the newly created group
                $new_group_id = $pdo->lastInsertId();

                // Automatically add the owner to the group_members table
                $sql_member = "INSERT INTO group_members (user_id, group_id) VALUES (:user_id, :group_id)";
                if($stmt_member = $pdo->prepare($sql_member)){
                    $stmt_member->bindParam(":user_id", $param_owner_id, PDO::PARAM_INT);
                    $stmt_member->bindParam(":group_id", $new_group_id, PDO::PARAM_INT);
                    $stmt_member->execute();
                    unset($stmt_member);
                }

                // Create a default '#general' text channel for the new group
                $sql_channel = "INSERT INTO channels (group_id, name, type) VALUES (:group_id, :name, :type)";
                if($stmt_channel = $pdo->prepare($sql_channel)){
                    $default_channel_name = "general";
                    $default_channel_type = "text";
                    $stmt_channel->bindParam(":group_id", $new_group_id, PDO::PARAM_INT);
                    $stmt_channel->bindParam(":name", $default_channel_name, PDO::PARAM_STR);
                    $stmt_channel->bindParam(":type", $default_channel_type, PDO::PARAM_STR);
                    $stmt_channel->execute();
                    unset($stmt_channel);
                }

                // Redirect to the main page or the newly created group page
                header("location: index.php"); // Redirect to main page for now
                exit();
            } else{
                echo "Something went wrong creating the group. Please try again later.";
            }

            // Close statement
            unset($stmt_group);
        }
    }
    
    // Close connection
    unset($pdo);
}

// This script primarily handles the POST request.
// The form itself will be in a separate file (e.g., create_group.php).

?>
