# Cortlak.com UI Mockup: Main Application View

**Goal:** Provide the core Discord-like interface for navigation and communication.

**Layout:** A three-column layout is standard and effective:

1.  **Leftmost Column (Group List):**
    - A narrow vertical bar displaying icons for the groups (servers) the user is a member of.
    - Each icon is circular or square with rounded corners.
    - A special icon at the top for "Home" or "Direct Messages".
    - An icon at the bottom for "Add a Group" or "Explore Groups".
    - Hovering over an icon could show the group name in a tooltip.
    - Clicking an icon selects the group and updates the middle column (Channel List).
    - Visual indicator (e.g., a white bar or shape next to the icon) for the currently selected group.
    - Notification badges on group icons for unread messages.

2.  **Middle Column (Channel List & User Info):**
    - **Top:** Displays the name of the currently selected group.
        - Dropdown menu for group settings (invites, settings, leave group, etc.) if the user has permissions.
    - **Middle:** Lists the channels within the selected group, categorized (e.g., Text Channels, Voice Channels).
        - Text channels usually prefixed with '#'.
        - Voice channels usually prefixed with a speaker icon.
        - Clicking a text channel loads its content in the rightmost column.
        - Clicking a voice channel connects the user to it (updates the User Info panel).
        - Indication of unread messages or mentions in text channels.
        - List of users currently in a voice channel might be shown indented below it.
        - Ability to create new channels (if permissions allow).
    - **Bottom (User Info Panel):**
        - User's avatar, username, and status indicator.
        - Buttons for mute, deafen, and user settings (like accessing profile/account settings).
        - Connection status for voice chat when connected.

3.  **Rightmost Column (Chat/Content Area):**
    - **Top Bar:** Displays the name of the selected text channel (e.g., "#general") or context (e.g., "Friends", Stream details).
        - Could include channel topic, pinned messages icon, member list toggle, search icon.
    - **Main Area (Message History):**
        - Displays the conversation history for the selected text channel.
        - Messages show user avatar, username, timestamp, and content.
        - Support for mentions, code blocks, emoji, file uploads, embeds.
        - Infinite scroll for loading older messages.
    - **Bottom (Message Input):**
        - Text input field for typing messages.
        - Buttons for file upload, emoji picker, GIF picker (optional).
        - Character limit indicator (optional).

**Styling:**
- Consistent with the Login/Register page (modern, clean, choice of dark/light theme).
- Clear visual separation between columns.
- Good use of whitespace.
- Responsive design to adapt to different screen sizes (columns might stack or hide on smaller screens).

