<?php
// Include the login processing script
include dirname(__DIR__) . 
'/app/auth/login_process.php';

// Include config for BASE_URL or other constants if needed
require_once dirname(__DIR__) . 
'/config/config.php';

// Check if the user is already logged in, if yes then redirect him to welcome page
// We need a welcome/main app page to redirect to. For now, let's assume it's index.php
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){ 
    // header("location: index.php"); // Redirect to main app page
    // exit;
    // For now, just show a message if already logged in on this page
    // echo "You are already logged in. Redirecting...";
    // Ideally, this check happens *before* any HTML output
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login - Cortlak.com</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: sans-serif; background-color: #f4f4f4; margin: 0; padding: 40px; display: flex; justify-content: center; align-items: center; min-height: 100vh; box-sizing: border-box; }
        .wrapper { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 100%; max-width: 400px; }
        h2 { text-align: center; color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; color: #555; }
        input[type="text"], input[type="password"] { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .help-block { color: #dc3545; font-size: 0.9em; margin-top: 5px; }
        .alert-danger { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; padding: 10px; border-radius: 4px; margin-bottom: 15px; }
        .btn { display: inline-block; width: 100%; padding: 10px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; text-align: center; }
        .btn:hover { background-color: #0056b3; }
        p { text-align: center; margin-top: 20px; }
        a { color: #007bff; text-decoration: none; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="wrapper">
        <h2>Login</h2>
        <p>Please fill in your credentials to login.</p>
        
        <?php 
        if(!empty($login_err)){ 
            echo '<div class="alert alert-danger">' . $login_err . '</div>';
        }
        ?>

        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="form-group <?php echo (!empty($login_identifier_err)) ? 'has-error' : ''; ?>">
                <label>Username or Email</label>
                <input type="text" name="login_identifier" value="<?php echo htmlspecialchars($login_identifier); ?>" placeholder="Enter your email or username">
                <span class="help-block"><?php echo $login_identifier_err; ?></span>
            </div>    
            <div class="form-group <?php echo (!empty($password_err)) ? 'has-error' : ''; ?>">
                <label>Password</label>
                <input type="password" name="password" placeholder="Enter your password">
                <span class="help-block"><?php echo $password_err; ?></span>
            </div>
            <div class="form-group">
                <input type="submit" class="btn" value="Login">
            </div>
            <p>Don't have an account? <a href="register.php">Sign up now</a>.</p>
            <!-- Optional: Add forgot password link here -->
        </form>
    </div>    
</body>
</html>
