<?php
// Include config file
require_once dirname(__DIR__, 2) . 
'/config/config.php';

// Define variables and initialize with empty values
$username = $email = $password = $confirm_password = "";
$username_err = $email_err = $password_err = $confirm_password_err = $registration_error = ""; // Added $registration_error

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){

    // Validate username
    if(empty(trim($_POST["username"]))){ 
        $username_err = "Lütfen bir kullanıcı adı girin.";
    } elseif(!preg_match('/^[a-zA-Z0-9_]+$/', trim($_POST["username"]))){ 
        $username_err = "Kullanıcı adı sadece harf, rakam ve alt çizgi içerebilir.";
    } else{
        // Prepare a select statement
        $sql_check_user = "SELECT id FROM users WHERE username = :username";
        try {
            if($stmt_check_user = $pdo->prepare($sql_check_user)){ 
                $stmt_check_user->bindParam(":username", $param_username_check, PDO::PARAM_STR);
                $param_username_check = trim($_POST["username"]);
                
                if($stmt_check_user->execute()){ 
                    if($stmt_check_user->rowCount() >= 1){ // Use >= 1 for safety
                        $username_err = "Bu kullanıcı adı zaten alınmış.";
                    } else{
                        $username = trim($_POST["username"]); // Keep the valid username
                    }
                } else{
                    $registration_error = "Kullanıcı adı kontrolü sırasında bir hata oluştu.";
                    // error_log("PDO Execute Error (Check Username): " . print_r($stmt_check_user->errorInfo(), true));
                }
                unset($stmt_check_user);
            } else {
                 $registration_error = "Kullanıcı adı kontrolü için veritabanı hazırlanamadı.";
                 // error_log("PDO Prepare Error (Check Username): " . print_r($pdo->errorInfo(), true));
            }
        } catch (PDOException $e) {
            $registration_error = "Kullanıcı adı kontrolü sırasında kritik bir veritabanı hatası oluştu.";
            error_log("PDO Exception (Check Username): " . $e->getMessage());
        }
    }
    
    // Validate email
    if(empty(trim($_POST["email"]))){ 
        $email_err = "Lütfen bir e-posta adresi girin.";
    } elseif (!filter_var(trim($_POST["email"]), FILTER_VALIDATE_EMAIL)) {
        $email_err = "Geçersiz e-posta formatı.";
    } else{
        // Prepare a select statement
        $sql_check_email = "SELECT id FROM users WHERE email = :email";
        try {
            if($stmt_check_email = $pdo->prepare($sql_check_email)){ 
                $stmt_check_email->bindParam(":email", $param_email_check, PDO::PARAM_STR);
                $param_email_check = trim($_POST["email"]);
                
                if($stmt_check_email->execute()){ 
                    if($stmt_check_email->rowCount() >= 1){ // Use >= 1 for safety
                        $email_err = "Bu e-posta adresi zaten kayıtlı.";
                    } else{
                        $email = trim($_POST["email"]); // Keep the valid email
                    }
                } else{
                    $registration_error = "E-posta kontrolü sırasında bir hata oluştu.";
                    // error_log("PDO Execute Error (Check Email): " . print_r($stmt_check_email->errorInfo(), true));
                }
                unset($stmt_check_email);
            } else {
                 $registration_error = "E-posta kontrolü için veritabanı hazırlanamadı.";
                 // error_log("PDO Prepare Error (Check Email): " . print_r($pdo->errorInfo(), true));
            }
        } catch (PDOException $e) {
            $registration_error = "E-posta kontrolü sırasında kritik bir veritabanı hatası oluştu.";
            error_log("PDO Exception (Check Email): " . $e->getMessage());
        }
    }
    
    // Validate password
    if(empty(trim($_POST["password"]))){ 
        $password_err = "Lütfen bir şifre girin.";     
    } elseif(strlen(trim($_POST["password"])) < 6){ 
        $password_err = "Şifre en az 6 karakter olmalıdır.";
    } else{
        $password = trim($_POST["password"]);
    }
    
    // Validate confirm password
    if(empty(trim($_POST["confirm_password"]))){ 
        $confirm_password_err = "Lütfen şifrenizi tekrar girin.";     
    } else{
        $confirm_password = trim($_POST["confirm_password"]);
        if(empty($password_err) && ($password != $confirm_password)){ 
            $confirm_password_err = "Şifreler eşleşmiyor.";
        }
    }
    
    // Check input errors before inserting in database
    // Also check the general registration error flag
    if(empty($username_err) && empty($email_err) && empty($password_err) && empty($confirm_password_err) && empty($registration_error)){ 
        
        // Prepare an insert statement
        $sql_insert = "INSERT INTO users (username, email, password_hash) VALUES (:username, :email, :password_hash)";
         
        if($stmt_insert = $pdo->prepare($sql_insert)){ 
            // Bind variables
            $stmt_insert->bindParam(":username", $param_username, PDO::PARAM_STR);
            $stmt_insert->bindParam(":email", $param_email, PDO::PARAM_STR);
            $stmt_insert->bindParam(":password_hash", $param_password_hash, PDO::PARAM_STR);
            
            // Set parameters
            $param_username = $username;
            $param_email = $email;
            $param_password_hash = password_hash($password, PASSWORD_DEFAULT);
            
            // Attempt to execute the prepared statement within a try-catch block
            try {
                if($stmt_insert->execute()){ 
                    // Redirect to login page on success
                    header("location: login.php?registration=success"); 
                    exit;
                } else{
                    // This else might not be reached if execute throws an exception
                    $registration_error = "Kayıt sırasında bilinmeyen bir hata oluştu.";
                    error_log("PDO Execute Error (Register Insert - Else Block): " . print_r($stmt_insert->errorInfo(), true));
                }
            } catch (PDOException $e) {
                // Check if it's a unique constraint violation (error code 23000)
                if ($e->getCode() == '23000') { 
                    // Check the error message to determine which constraint failed
                    if (strpos(strtolower($e->getMessage()), 'unique constraint failed: users.email') !== false || strpos(strtolower($e->getMessage()), 'for key \'email\'') !== false) {
                         $email_err = "Bu e-posta adresi zaten kayıtlı (veritabanı hatası).";
                    } elseif (strpos(strtolower($e->getMessage()), 'unique constraint failed: users.username') !== false || strpos(strtolower($e->getMessage()), 'for key \'username\'') !== false) {
                         $username_err = "Bu kullanıcı adı zaten alınmış (veritabanı hatası).";
                    } else {
                         // Generic integrity error
                         $registration_error = "Veritabanı bütünlüğü hatası oluştu.";
                    }
                } else {
                    // Other PDO exception
                    $registration_error = "Kayıt sırasında kritik bir veritabanı hatası oluştu.";
                }
                 // Log the detailed error regardless
                 error_log("PDO Exception (Register Insert): " . $e->getMessage());
            }

            // Close insert statement
            unset($stmt_insert);
        } else {
             $registration_error = "Kayıt için veritabanı hazırlanamadı.";
             error_log("PDO Prepare Error (Register Insert): " . print_r($pdo->errorInfo(), true));
        }
    }
    
    // Close connection (optional, PHP usually handles this at script end)
    // unset($pdo);
}

// The register.php file includes this script and will display any errors set in 
// $username_err, $email_err, $password_err, $confirm_password_err, or $registration_error.
?>
