<?php
require_once dirname(__DIR__) . '/config/config.php';

// Check if the user is logged in, otherwise redirect to login page
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
    header("location: login.php?redirect=invite&code=" . urlencode($_GET['code'] ?? ''));
    exit;
}

$user_id = $_SESSION['id'];
$invite_code = null;
$error_message = '';
$success_message = '';
$group_id_to_redirect = null;

if (isset($_GET['code'])) {
    $invite_code = trim($_GET['code']);

    if (empty($invite_code)) {
        $error_message = "Invite code is missing.";
    } else {
        // Find the invitation
        $sql_find_invite = "SELECT id, group_id, expires_at, max_uses, uses FROM invitations WHERE code = :code";
        $stmt_find = $pdo->prepare($sql_find_invite);
        $stmt_find->bindParam(':code', $invite_code, PDO::PARAM_STR);
        
        if ($stmt_find->execute()) {
            $invite = $stmt_find->fetch();

            if ($invite) {
                $group_id = $invite['group_id'];
                $invite_id = $invite['id'];
                $expires_at = $invite['expires_at'];
                $max_uses = $invite['max_uses'];
                $current_uses = $invite['uses'];

                // Check if expired
                if ($expires_at !== null && strtotime($expires_at) < time()) {
                    $error_message = "This invite link has expired.";
                } 
                // Check if usage limit reached
                elseif ($max_uses > 0 && $current_uses >= $max_uses) {
                    $error_message = "This invite link has reached its maximum number of uses.";
                } else {
                    // Check if user is already a member
                    $sql_check_member = "SELECT 1 FROM group_members WHERE user_id = :user_id AND group_id = :group_id";
                    $stmt_check = $pdo->prepare($sql_check_member);
                    $stmt_check->bindParam(':user_id', $user_id, PDO::PARAM_INT);
                    $stmt_check->bindParam(':group_id', $group_id, PDO::PARAM_INT);
                    $stmt_check->execute();

                    if ($stmt_check->rowCount() > 0) {
                        $error_message = "You are already a member of this group.";
                        $group_id_to_redirect = $group_id; // Allow redirect even if already a member
                    } else {
                        // Add user to the group
                        $sql_add_member = "INSERT INTO group_members (user_id, group_id) VALUES (:user_id, :group_id)";
                        $stmt_add = $pdo->prepare($sql_add_member);
                        $stmt_add->bindParam(':user_id', $user_id, PDO::PARAM_INT);
                        $stmt_add->bindParam(':group_id', $group_id, PDO::PARAM_INT);

                        if ($stmt_add->execute()) {
                            // Increment usage count if applicable
                            if ($max_uses > 0) {
                                $sql_update_uses = "UPDATE invitations SET uses = uses + 1 WHERE id = :invite_id";
                                $stmt_update = $pdo->prepare($sql_update_uses);
                                $stmt_update->bindParam(':invite_id', $invite_id, PDO::PARAM_INT);
                                $stmt_update->execute();
                                unset($stmt_update);
                            }
                            $success_message = "Successfully joined the group!";
                            $group_id_to_redirect = $group_id;
                        } else {
                            $error_message = "Failed to join the group. Please try again.";
                        }
                        unset($stmt_add);
                    }
                    unset($stmt_check);
                }
            } else {
                $error_message = "Invalid invite code.";
            }
        } else {
            $error_message = "Database error checking invite code.";
        }
        unset($stmt_find);
    }
} else {
    $error_message = "No invite code provided.";
}

// Redirect if successful or already a member
if ($group_id_to_redirect) {
    header("location: index.php?group_id=" . $group_id_to_redirect);
    exit;
}

// Close connection
unset($pdo);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Join Group - Cortlak.com</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: sans-serif; background-color: #f4f4f4; margin: 0; padding: 40px; display: flex; justify-content: center; align-items: center; min-height: 100vh; box-sizing: border-box; }
        .message-box { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 100%; max-width: 400px; text-align: center; }
        .error { color: #dc3545; }
        .success { color: #28a745; }
        a { color: #007bff; text-decoration: none; margin-top: 15px; display: inline-block; }
        a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="message-box">
        <?php if (!empty($error_message)): ?>
            <h2 class="error">Error</h2>
            <p><?php echo htmlspecialchars($error_message); ?></p>
        <?php elseif (!empty($success_message)): ?>
            <h2 class="success">Success</h2>
            <p><?php echo htmlspecialchars($success_message); ?></p>
            <p>Redirecting...</p>
            <script>setTimeout(function(){ window.location.href = 'index.php'; }, 2000);</script> 
        <?php else: ?>
             <p>Processing your request...</p> 
        <?php endif; ?>
        <p><a href="index.php">Go to Dashboard</a></p>
    </div>
</body>
</html>

