<?php
require_once dirname(__DIR__) . 
'/config/config.php';

$stream_user_id = null;
$stream_info = null;
$user_info = null;
$error_message = '';

if (isset($_GET[
'user
']) && is_numeric($_GET[
'user
'])) {
    $stream_user_id = (int)$_GET[
'user
'];

    // Fetch stream details and user info
    $sql = "SELECT s.title, s.description, s.is_live, u.username 
            FROM streams s 
            JOIN users u ON s.user_id = u.id 
            WHERE s.user_id = :user_id";
    
    if ($stmt = $pdo->prepare($sql)) {
        $stmt->bindParam(":user_id", $stream_user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $stream_info = $stmt->fetch();
            if ($stream_info) {
                // Fetch user info separately if needed, or join as above
                // $user_info = ... (already got username in the join)
            } else {
                $error_message = "Stream configuration not found for this user.";
            }
        } else {
            $error_message = "Error fetching stream details.";
        }
        unset($stmt);
    } else {
        $error_message = "Database error preparing statement.";
    }

} else {
    $error_message = "No user specified for the stream.";
}

unset($pdo);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $stream_info ? htmlspecialchars($stream_info[
'title
']) : 'Watch Stream'; ?> - Cortlak.com</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: sans-serif; background-color: #18181b; color: #efeff1; margin: 0; padding: 0; display: flex; flex-direction: column; height: 100vh; }
        .header { background-color: #1f1f23; padding: 10px 20px; border-bottom: 1px solid #3a3a3d; }
        .header a { color: #a970ff; text-decoration: none; font-weight: bold; }
        .main-content { display: flex; flex-grow: 1; overflow: hidden; }
        .stream-area { flex-grow: 1; background-color: #0e0e10; display: flex; flex-direction: column; padding: 20px; }
        .video-placeholder { background-color: #000; aspect-ratio: 16 / 9; width: 100%; max-width: 1280px; margin: 0 auto; display: flex; align-items: center; justify-content: center; font-size: 1.5em; color: #555; border: 1px solid #333; }
        .stream-info { margin-top: 15px; max-width: 1280px; margin-left: auto; margin-right: auto; }
        .stream-title { font-size: 1.4em; font-weight: bold; margin-bottom: 5px; }
        .streamer-name { color: #a970ff; font-weight: 600; margin-bottom: 10px; }
        .stream-description { color: #adadb8; }
        .status { display: inline-block; padding: 2px 6px; border-radius: 4px; font-size: 0.8em; margin-left: 10px; }
        .status.live { background-color: red; color: white; }
        .status.offline { background-color: gray; color: white; }
        .chat-area { width: 340px; background-color: #1f1f23; border-left: 1px solid #3a3a3d; display: flex; flex-direction: column; flex-shrink: 0; }
        .chat-header { padding: 15px; font-weight: bold; border-bottom: 1px solid #3a3a3d; }
        .chat-messages { flex-grow: 1; overflow-y: auto; padding: 15px; }
        .chat-input { padding: 15px; border-top: 1px solid #3a3a3d; }
        .chat-input input { width: 100%; background-color: #464649; border: 1px solid #6441a5; border-radius: 4px; padding: 10px; color: #efeff1; box-sizing: border-box; }
        .error-message { color: #ff7b7b; text-align: center; padding: 50px; font-size: 1.2em; }
    </style>
</head>
<body>
    <div class="header">
        <a href="index.php">Back to Cortlak</a>
    </div>

    <?php if ($stream_info): ?>
    <div class="main-content">
        <div class="stream-area">
            <div class="video-placeholder">
                <?php if ($stream_info[
'is_live
']): ?>
                    Video Player Placeholder (Stream is Live)
                    <!-- In a real implementation, embed a video player here (e.g., Video.js, HLS.js) -->
                    <!-- The source would likely be an HLS or DASH manifest from the media server -->
                <?php else: ?>
                    Stream is Offline
                <?php endif; ?>
            </div>
            <div class="stream-info">
                <h1 class="stream-title"><?php echo htmlspecialchars($stream_info[
'title
']); ?> <span class="status <?php echo $stream_info[
'is_live
'] ? 'live' : 'offline'; ?>"><?php echo $stream_info[
'is_live
'] ? 'LIVE' : 'OFFLINE'; ?></span></h1>
                <div class="streamer-name"><?php echo htmlspecialchars($stream_info[
'username
']); ?></div>
                <p class="stream-description"><?php echo nl2br(htmlspecialchars($stream_info[
'description
'])); ?></p>
            </div>
        </div>
        <div class="chat-area">
            <div class="chat-header">Stream Chat</div>
            <div class="chat-messages">
                <!-- Chat messages would be loaded here, likely via JavaScript/WebSockets -->
                <p style="color: #888; text-align: center;">Chat is not implemented yet.</p>
            </div>
            <div class="chat-input">
                <input type="text" placeholder="Send a message" disabled>
            </div>
        </div>
    </div>
    <?php else: ?>
        <div class="error-message">
            <h2>Error</h2>
            <p><?php echo htmlspecialchars($error_message ?: "Could not load stream information."); ?></p>
        </div>
    <?php endif; ?>

</body>
</html>
